/*
 * diaglib-dbus.h
 *
 *  Created on: Mar 15, 2016
 *      Author: rjk2kor
 */

#ifndef DIAGDEFSET_DIAGLIB_DBUS_H_
#define DIAGDEFSET_DIAGLIB_DBUS_H_

#include "aud_diag_defset_adaptor_IF.h"

class CAmControlSenderBase;

class diaglib_dbus : public aud_diag_defset_adaptor_IF
{

private:
  //Explicit privates
  diaglib_dbus();
  diaglib_dbus(const diaglib_dbus& );
public:
  diaglib_dbus(DBusConnection* x, CAmControlSenderBase* y);
  virtual ~diaglib_dbus();
private:
  CAmControlSenderBase* m_poSenderBase;
  //Function should return the result of the operation
  ///Function triggered by diagnosis asking to prepare for system setting
  virtual uint32_t u32OnPrepareSystemSetting(std::string& rfSysSetId, std::string& rfSyssetType);
  ///Function triggered by diagnosis asking to execute system setting
  virtual uint32_t u32OnExecuteSystemSetting(std::string& rfSysSetId, std::string& rfSyssetType);
  ///Function triggered by diagnosis asking to Finalize for system setting
  virtual uint32_t u32OnFinalizeSystemSetting(std::string& rfSysSetId, std::string& rfSyssetType);
  //Helper function to check if is applicable
  bool bIsApplicable(std::string& rfSysSetId, std::string& rfSyssetType);

};

#include "aud_dbus_connector.h"

/**
* Class to handle construction and destruction of diaglibdbus, watches, timers etc
*/
class aud_diaglib_handler
{
private:
  //Explicit privates, disable copy construction
  aud_diaglib_handler(const aud_diaglib_handler& );

  bool bStandalone;//Private connection to bus
  DBusConnection *m_ptrConnection;//Dbus connection

  diaglib_dbus* m_pDiaglib;
  aud_ml_dbus_watch_connector* m_pWatchConnector;
  aud_ml_dbus_timer_connector* m_pTimerConnector;
public:
  aud_diaglib_handler();
  bool Init(am::CAmSocketHandler* poMainLoop,CAmControlSenderBase* pSenderbase);
  void DeInit();
  ~aud_diaglib_handler();
};



#endif /* DIAGDEFSET_DIAGLIB_DBUS_H_ */
